package org.openmetadata.store.repository.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openmetadata.store.managers.AccessManager;
import org.openmetadata.store.repository.Repository;

public abstract class ARepositoryImpl<Item extends Object> implements Repository<Item> {

	protected Log logger = LogFactory.getLog(getClass());
	private AccessManager accessManager;
	
	public void setAccessManager(AccessManager accessManager) {
		if (this.accessManager != null
				&& !this.accessManager.equals(accessManager)) {
			String msg = "AccessManager cannot be reset.";
			logger.error(msg);
			throw new RuntimeException(msg);
		}
		this.accessManager = accessManager;
	}

	public final AccessManager getAccessManager() {
		if (accessManager == null) {
			String msg = "AccessManager is not set.";
			logger.error(msg);
			throw new RuntimeException(msg);
		}
		return accessManager;
	}
	
}
