package org.openmetadata.store.repository;

import org.openmetadata.beans.IdentifiableBean;
import org.openmetadata.beans.deserialization.MutableDeserializer;
import org.openmetadata.beans.factory.BeanFactory;
import org.openmetadata.beans.notification.IdentifiableChangeListener;
import org.openmetadata.beans.reference.Resolver;
import org.openmetadata.beans.serialization.Serializer;
import org.openmetadata.store.catalog.WorkspaceCatalogProvider;
import org.openmetadata.store.managers.ChangeManager;

/**
 * TODO Fill in all documentation
 * 
 * @author Jack Gager
 * 
 * @param <Item>
 */
public interface WorkspaceRepository<Item extends Object> extends
		StoreRepository<Item>, MutableRepository<Item>,
		WorkspaceCatalogProvider {

	/**
	 * Returns the {@link ChangeManager} for this repository. The change manager
	 * is responsible for processing change events and tracking which need to be
	 * saved based on the structure of the repository.
	 * 
	 * @return
	 */
	public ChangeManager getChangeManager();

	/**
	 * Returns a new instance of the {@link BeanFactory} for the repository
	 * without the {@link Resolver} or {@link IdentifiableChangeListener} set to
	 * it. This allows the workspace which will use the factory to set itself as
	 * the resolver and change listener.
	 * 
	 * @return
	 */
	public BeanFactory getBeanFactory();

	/**
	 * Returns the {@link MutableDeserializer} for the repository without the
	 * {@link Resolver} or {@link IdentifiableChangeListener} set to it. This
	 * allows the workspace which will use the deserializer to set itself as the
	 * resolver and change listener.
	 * 
	 * @return
	 */
	@Override
	public MutableDeserializer<Item> getDeserializer();

	/**
	 * Returns the {@link Serializer} that must be used to to serialize
	 * {@link IdentifiableBean}s into the appropriate format for saving changes
	 * to this repository.
	 * 
	 * @return and implementation of a <code>Serializer</code>
	 */
	public Serializer<Item> getSerializer();

}
