package org.openmetadata.store.repository;

import org.openmetadata.store.catalog.ClientWorkspaceCatalog;
import org.openmetadata.store.catalog.ClientWorkspaceCatalogProvider;
import org.openmetadata.store.change.ChangeSet;
import org.openmetadata.store.exceptions.StoreException;
import org.openmetadata.store.managers.LocalLockManager;

/**
 * This is a repository that is a client for a central repository. It allows for
 * objects to be loaded into it from the central repository.
 * 
 * TODO: Update documentation to reflect that this determines what can and
 * cannot be individually committed.
 * 
 * @author Jack Gager
 * 
 * @param <Item>
 *            the base object for which any object which exists in the
 *            repository derives from.
 */
public interface ClientWorkspaceRepository<Item extends Object> extends
		WorkspaceRepository<Item>, ClientWorkspaceCatalogProvider {

	/**
	 * Returns the list of object identifiers which have been changed but have
	 * not been committed to the shared repository.
	 * 
	 * TODO: Update documentation to reflect that this only contains identifiers
	 * that can actually be committed.
	 * 
	 * @return a <code>Set</code> of identifiers detailing the uncommitted
	 *         changes (additions, updates, and deletions).
	 */
	public ChangeSet<String> getUncommitedChanges();

	/**
	 * Checks whether an object with the supplied identifier exists in the
	 * central repository
	 * 
	 * @param id
	 *            the identifier of the object to check for
	 * @return <code>true</code> is the object exists, <code>false</code>
	 *         otherwise
	 */
	public boolean exists(String id);

	public String commitChanges(String id) throws StoreException;

	public String commitAllChanges() throws StoreException;

	public String revertChanges(String id);

	public String revertAllChanges();

	public LocalLockManager getLockManager();

	public ClientWorkspaceCatalog refreshCatalog();
	
	public void setOffline(boolean offline);

}
