package org.openmetadata.store.query.impl;

import java.util.HashSet;
import java.util.Set;

import org.openmetadata.store.query.TextSearch;

public class TextSearchImpl implements TextSearch {
	
	private final HashSet<Enum<?>> languages;
	private final HashSet<Enum<?>> fields;
	private final String text;
	
	public TextSearchImpl(Set<Enum<?>> languages, Set<Enum<?>> fields, String text) {
		this.languages = new HashSet<Enum<?>>(languages);
		this.fields = new HashSet<Enum<?>>(fields);
		this.text = text;
	}
	
	@Override
	public Set<Enum<?>> getLanguages() {
		return languages;
	}

	@Override
	public Set<Enum<?>> getSearchFields() {
		return fields;
	}

	@Override
	public String getSearchText() {
		return text;
	}

}
