package org.openmetadata.store.query.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

import org.openmetadata.store.query.Result;
import org.openmetadata.store.query.SearchResult;

public class SearchResultImpl implements SearchResult {

	private final boolean isComplete;
	private final LinkedHashSet<Result> results;

	public SearchResultImpl(boolean isComplete, Result... results) {
		this.isComplete = isComplete;
		this.results = new LinkedHashSet<Result>();
		for (Result result : results) {
			this.results.add(result);
		}
	}

	public SearchResultImpl(String... ids) {
		this(Arrays.asList(ids));
	}

	public SearchResultImpl(Collection<String> ids) {
		this(true);
		if (ids != null) {
			for (String id : ids) {
				this.results.add(new ResultImpl(id));
			}
		}
	}

	@Override
	public boolean isComplete() {
		return isComplete;
	}

	@Override
	public Set<Result> getResults() {
		return results;
	}

}
