package org.openmetadata.store.query.impl;

import java.util.HashSet;
import java.util.Set;

import org.openmetadata.store.query.ReferenceSet;

public class ReferenceSetImpl implements ReferenceSet {

	private final HashSet<Set<String>> idSets;
	private boolean directReferences = true;

	public ReferenceSetImpl() {
		idSets = new HashSet<Set<String>>();
	}

	public void setDirectReferences(boolean directReferences) {
		this.directReferences = directReferences;
	}

	@Override
	public boolean directReferences() {
		return directReferences;
	}

	@Override
	public Set<Set<String>> getIdSets() {
		return idSets;
	}
	
	public void addIds(Set<String> ids) {
		idSets.add(ids);
	}

}
