package org.openmetadata.store.query.impl;

import java.util.HashSet;
import java.util.Set;

import org.openmetadata.store.query.PropertySearch;
import org.openmetadata.store.query.PropertyValue;

public class PropertySearchImpl implements PropertySearch {
	
	private final Enum<?> property;
	private final HashSet<PropertyValue> values;
	
	public PropertySearchImpl(Enum<?> property, PropertyValue...values) {
		this.property = property;
		this.values = new HashSet<PropertyValue>();
		for (PropertyValue value : values) {
			this.values.add(value);
		}
	}
	
	@Override
	public Enum<?> getProperty() {
		return property;
	}

	@Override
	public Set<PropertyValue> getValues() {
		return new HashSet<PropertyValue>(values);
	}
	
	public void addValue(PropertyValue value) {
		values.add(value);
	}
	
}
