package org.openmetadata.store.query;

/**
 * Provides for specification of sorting on query results.
 * 
 * @author Jack Gager
 *
 */
public interface Sort {
	
	/**
	 * Retrieves the property to which this sort applies. The enumeration must
	 * be agreed upon by the query provider and processor. If the process does
	 * not recognize an enumeration, it must throw an
	 * <code>InvalidCriteriaException</code>.
	 * 
	 * @return an enumeration designating the property to be sorted on
	 */
	public Enum<?> getField();
	
	/**
	 * Retrieves the sort order to apply to the specified field
	 * 
	 * @return the sort oder
	 */
	public SortOrder getOrder();
	
}
