package org.openmetadata.store.query;

import java.util.Set;

/**
 * Provides for a set of identifiers matching a {@link Criteria}.
 * 
 * @author Jack Gager
 * 
 */
public interface SearchResult {

	/**
	 * Indicates whether the result set is complete or whether it has been
	 * truncated.
	 * 
	 * @return <code>true</code> is the result set is complete,
	 *         <code>false</code> if it has been truncated
	 */
	public boolean isComplete();

	/**
	 * Returns the set of identifiers satisfying the query criteria.
	 * 
	 * @return a set of identifiers
	 */
	public Set<Result> getResults();

}
