package org.openmetadata.store.query;

import java.util.Set;

/**
 * This is used for querying based on a reference to or from the objects
 * identified in {@link #getIdSets()}.
 * 
 * @author Jack Gager
 * 
 */
public interface ReferenceSet {

	/**
	 * Indicates whether the query should only take into account direct
	 * references. If <code>false</code>, then it is assumed the query applies
	 * to indirect references as well.
	 * 
	 * @return <code>true</code> if the set of references are direct
	 */
	public boolean directReferences();

	/**
	 * Returns the set of references identifiers which are to be queried
	 * against. This is a set of identifier sets. An identifier set (the inner
	 * set) is matched if any of the identifiers contained within it match (i.e.
	 * the identifiers are "OR" joined within the inner set). The entire set of
	 * identifier sets (the outer set) is matched if all identifier sets are
	 * matched (i.e the inner sets are "AND" joined within the outer set).
	 * <p>
	 * 
	 * @return
	 */
	public Set<Set<String>> getIdSets();

}
