package org.openmetadata.store.query;

/**
 * Provides a value for a {@link PropertySearch}.
 * 
 * @author Jack Gager
 * 
 */
public interface PropertyValue {

	/**
	 * The property value for the search.
	 * 
	 * @return the property value
	 */
	public Object getValue();

	/**
	 * The operator to be applied to the value.
	 * 
	 * @return the property value operator
	 */
	public Operator getOperator();

}
