package org.openmetadata.store.managers.impl;

import org.openmetadata.beans.IdentifiableBean;
import org.openmetadata.store.access.AccessRights;
import org.openmetadata.store.access.impl.ReadOnlyAccess;
import org.openmetadata.store.managers.AccessManager;

public class ReadOnlyAccessManager implements AccessManager {
	
	private final ReadOnlyAccess rights;
	
	public ReadOnlyAccessManager() {
		rights = new ReadOnlyAccess();
	}
	
	@Override
	public AccessRights getRights(IdentifiableBean bean) {
		return rights;
	}

	@Override
	public AccessRights getRights(Class<? extends IdentifiableBean> beanClass) {
		return rights;
	}

}
