package org.openmetadata.store.managers;

import org.openmetadata.beans.IdentifiableBean;
import org.openmetadata.store.access.LockInformation;

/**
 * This manages locks on shared instances of {@link IdentifiableBean}s for
 * editing purposes. This interacts with a shared repository space. An instance
 * of this is associated with a single user of the shared repository. Therefore,
 * the methods do not have user information associated with them.
 * 
 * @author Jack Gager
 * 
 */
public interface LocalLockManager extends LockManager {

	/**
	 * Returns all active locks from the repository from which the objects are
	 * being locked. This will contain all lock information for all repository
	 * users for which the user associated with this manager is able to view.
	 * 
	 * @return active locks as an array of {@link LockInformation}
	 * 
	 * @see #getLocks() getLocalLocks
	 */
	public LockInformation[] getRepositoryLocks();

}
