package org.openmetadata.store.managers;


/**
 * TODO: Update this description
 * 
 * @author Jack Gager
 * 
 */
public interface ContextManager {

	/**
	 * Looks up whether an object is a context object.
	 * 
	 * @param id
	 *            the identifier of the object to look up
	 * @return <code>true</code> if the object is a context object, otherwise
	 *         <code>false</code>
	 */
	public boolean isContext(String id);


	/**
	 * Looks up whether an object can be saved on its own. If the result is
	 * false, it does not mean that the object will not be saved, but rather
	 * that the object can only be saved by saving the object within the context
	 * it exists.
	 * 
	 * @param id
	 *            the identifier of the object for which the ability to save is
	 *            being sought
	 * @return <code>true</code> if the object can be saved on its own,
	 *         otherwise <code>false</code>
	 */
	public boolean canSave(String id);

}
