package org.openmetadata.store.managers;

import org.openmetadata.beans.IdentifiableBean;
import org.openmetadata.store.access.AccessRights;

/**
 * This is used to determine the access rights for {@link IdentifiableBean}
 * instances or types. Instances of this are assigned to a particular user,
 * therefore the methods have no user information associated with them.
 * 
 * @author Jack Gager
 * 
 */
public interface AccessManager {

	/**
	 * Get the access right information for a given bean instance
	 * 
	 * @param bean
	 *            the <code>IdentifiableBean</code> instance for which the
	 *            access rights are sought
	 * @return the access rights for the bean instance
	 */
	public AccessRights getRights(IdentifiableBean bean);

	/**
	 * Gets the general access right information for a particular type of
	 * <code>IdentifiableBean</code>. The rights returned here may be superseded
	 * by the rights for a particular instance of the bean type.
	 * 
	 * @param beanClass
	 *            the <code>IdentifiableBean</code> type for which the general
	 *            access rights are sought
	 * @return
	 */
	public AccessRights getRights(Class<? extends IdentifiableBean> beanClass);

}
