package org.openmetadata.store.impl;

import org.openmetadata.store.SharedWorkspace;
import org.openmetadata.store.managers.LocalLockManager;
import org.openmetadata.store.repository.SharedWorkspaceRepository;
import org.openmetadata.store.repository.StoreRepository;
import org.openmetadata.store.repository.WorkspaceRepository;

public class SharedWorkspaceImpl<Source extends Object> extends WorkspaceImpl<Source>
		implements SharedWorkspace {
	
	private SharedWorkspaceRepository<Source> sharedWorkspaceRepository;
	
	public SharedWorkspaceImpl(String contextId) {
		this (contextId, true);
	}
	
	public SharedWorkspaceImpl(String contextId, boolean mustDeserialize) {
		super(contextId, mustDeserialize);
	}

	@Override
	public LocalLockManager getLockManager() {
		return getSharedWorkspaceRepository();
	}

	@Override
	public void setStoreRepository(StoreRepository<Source> storeRepository) {
		super.setStoreRepository(storeRepository);
		logger.warn("StoreRepository must be set via the SharedWorkspaceRespository property. "
				+ "Repository set as StoreRepository property will be overridden.");
	}

	public void setWorkspaceRepository(
			WorkspaceRepository<Source> workspaceRepository) {
		super.setWorkspaceRepository(workspaceRepository);
		logger.warn("WorkspaceRepository must be set via the SharedWorkspaceRespository property. "
				+ "Repository set as WorkspaceRepository property will be overridden.");
	}
	
	public void setSharedWorksapceRepository(
			SharedWorkspaceRepository<Source> sharedWorkspaceRepository) {
		if (this.sharedWorkspaceRepository != null
				&& !this.sharedWorkspaceRepository.equals(sharedWorkspaceRepository)) {
			throw raiseRuntimeException("SharedWorkspaceRepository cannot be reset.");
		}
		super.setWorkspaceRepository(sharedWorkspaceRepository);
		this.sharedWorkspaceRepository = sharedWorkspaceRepository;
	}
	
	protected final SharedWorkspaceRepository<Source> getSharedWorkspaceRepository() {
		if (sharedWorkspaceRepository == null) {
			throw raiseRuntimeException("SharedWorkspaceRepository is not set.");
		}
		return sharedWorkspaceRepository;
	}
	
}
