package org.openmetadata.store.exceptions;

import java.util.Arrays;

public class ObjectNotFoundException extends StoreException {

	private static final long serialVersionUID = -8626396066856564533L;
	private final String[] primaryIdentifiers;

	public ObjectNotFoundException(String... primaryIdentifiers) {
		super("Object(s): " + Arrays.toString(primaryIdentifiers) + " could not be found.");
		this.primaryIdentifiers = primaryIdentifiers;
	}

	public String[] getPrimaryIdentifiers() {
		return primaryIdentifiers;
	}

}
