package org.openmetadata.store.exceptions;

import org.openmetadata.store.access.AccessRights;

public class InsufficientRightsException extends StoreException {

	private static final long serialVersionUID = 3782050941647595252L;
	private final AccessRights rights;

	public InsufficientRightsException(AccessRights rights) {
		super("Insufficient rights for request.");
		this.rights = rights;
	}

	public AccessRights getAvailableRights() {
		return rights;
	}

}
