package org.openmetadata.store.exceptions;

import org.openmetadata.store.access.LockInformation;

public class ExistingLockException extends StoreException {

	private static final long serialVersionUID = -1929720848303650734L;
	private final LockInformation lockInformation;
	
	public ExistingLockException(LockInformation lockInformation) {
		super("Object is already locked.");
		this.lockInformation = lockInformation;
	}
	
	public LockInformation getExistingLock() {
		return lockInformation;
	}
	
}
