package org.openmetadata.store.change.impl;

import java.util.HashSet;
import java.util.Set;

import org.openmetadata.store.change.ChangeSet;

public abstract class AChangeSetImpl<Item extends Object> implements
		ChangeSet<Item> {
	
	protected final HashSet<Item> additionSet;
	protected final HashSet<Item> deletionSet;
	protected final HashSet<Item> updateSet;
	
	public AChangeSetImpl() {
		additionSet = new HashSet<Item>();
		deletionSet = new HashSet<Item>();
		updateSet = new HashSet<Item>();
	}
	
	@Override
	public final Set<Item> getAdditions() {
		return additionSet;
	}

	@Override
	public final Set<Item> getDeletions() {
		return deletionSet;
	}

	@Override
	public final Set<Item> getUpdates() {
		return updateSet;
	}
	
}
