package org.openmetadata.store.change;

/**
 * Contains the details of the changes associated with a context object. Saving
 * the context object will result in saving all additions, deletions, and
 * updates, as detailed in the {@link ChangeSet}.
 * 
 * @author Jack Gager
 * 
 */
public interface ContextChanges {

	/**
	 * Gets the identifier of the context <code>IdentifiableBean</code>. This is
	 * the identifier the should be used to save the changes.
	 * 
	 * @return the primary identifier for the context bean
	 */
	public String getContextId();

	/**
	 * Returns the <code>ChangeInformation</code> detailing which objects have
	 * been modified, added, and deleted within the context of the context
	 * object.
	 * 
	 * @return the change details
	 */
	public ChangeSet<String> getChangeDetails();

}
