package org.openmetadata.store.change;

import java.util.Set;

/**
 * Contains the details of a collection of changes to {@link IdentifiableBean}
 * objects. The details can be expressed in any form, such as the actual beans,
 * the source objects which they are serialized to, or simply a set of
 * identifiers.
 * 
 * @author Jack Gager
 * 
 * @param <Item>
 *            the base class in which all changed object are expressed in this
 *            collection
 */
public interface ChangeSet<Item extends Object> {

	/**
	 * Returns the set of object for the beans that have been newly
	 * created.
	 * 
	 * @return a non-backed set of object for added objects
	 */
	public Set<Item> getAdditions();

	/**
	 * Returns the set of object for the beans that have been deleted.
	 * 
	 * @return a non-backed set of objects for deleted objects
	 */
	public Set<Item> getDeletions();

	/**
	 * Returns the set of object for the beans that have been updated.
	 * 
	 * @return a non-backed set of object for updated objects
	 */
	public Set<Item> getUpdates();
	
}
