package org.openmetadata.store.catalog.impl;

import org.openmetadata.beans.IdentifiableBean;
import org.openmetadata.store.catalog.SharedWorkspaceLevel;
import org.openmetadata.store.catalog.SharedWorkspaceNode;
import org.openmetadata.text.ContextualTextSet;

public class SharedWorkspaceNodeImpl
		extends
		ASharedWorkspaceNodeImpl<SharedWorkspaceNodeImpl, SharedWorkspaceLevelImpl> {

	public SharedWorkspaceNodeImpl(SharedWorkspaceNode node) {
		this(node.getPrimaryIdentifier(), node.getType(), node.getName(), node
				.getDescription(), node.getContextId(), null, null);
	}

	public SharedWorkspaceNodeImpl(SharedWorkspaceNode node,
			SharedWorkspaceLevelImpl parentLevel) {
		this(node.getPrimaryIdentifier(), node.getType(), node.getName(), node
				.getDescription(), node.getContextId(), parentLevel, null);
	}

	public SharedWorkspaceNodeImpl(SharedWorkspaceNode node,
			SharedWorkspaceNodeImpl parentNode) {
		this(node.getPrimaryIdentifier(), node.getType(), node.getName(), node
				.getDescription(), node.getContextId(), null, parentNode);
	}

	public SharedWorkspaceNodeImpl(SharedWorkspaceNode node,
			SharedWorkspaceLevelImpl parentLevel,
			SharedWorkspaceNodeImpl parentNode) {
		this(node.getPrimaryIdentifier(), node.getType(), node.getName(), node
				.getDescription(), node.getContextId(), parentLevel, parentNode);
		for (SharedWorkspaceLevel child : node.getLevels()) {
			addLevel(new SharedWorkspaceLevelImpl(child, this));
		}
		for (SharedWorkspaceNode child : node.getNodes()) {
			addNode(new SharedWorkspaceNodeImpl(child, this));
		}
		setCanLock(node.canLock());
		setIsLocked(node.isLockedByLocal() || node.isLockedByOther(), node.isLockedByLocal());
		setSaveState(node.getSaveState());
	}

	public SharedWorkspaceNodeImpl(String id,
			Class<? extends IdentifiableBean> type, ContextualTextSet name,
			ContextualTextSet description, String contextId,
			SharedWorkspaceLevelImpl parentLevel,
			SharedWorkspaceNodeImpl parentNode) {
		super(id, type, name, description, contextId, parentLevel, parentNode);
	}

	@Override
	protected SharedWorkspaceNodeImpl[] buildNodeArray() {
		return new SharedWorkspaceNodeImpl[0];
	}

	@Override
	protected SharedWorkspaceLevelImpl[] buildLevelArray() {
		return new SharedWorkspaceLevelImpl[0];
	}

}
