package org.openmetadata.store.catalog.impl;

import org.openmetadata.store.catalog.SharedWorkspaceLevel;
import org.openmetadata.store.catalog.SharedWorkspaceNode;
import org.openmetadata.text.ContextualTextSet;

public class SharedWorkspaceLevelImpl
		extends
		ASharedWorkspaceLevelImpl<SharedWorkspaceNodeImpl, SharedWorkspaceLevelImpl> {

	public SharedWorkspaceLevelImpl(SharedWorkspaceLevel level) {
		this(level.getName(), level.getDescription(), level.getContextId(),
				null, null);
	}

	public SharedWorkspaceLevelImpl(SharedWorkspaceLevel level,
			SharedWorkspaceLevelImpl parentLevel) {
		this(level.getName(), level.getDescription(), level.getContextId(),
				parentLevel, null);
	}

	public SharedWorkspaceLevelImpl(SharedWorkspaceLevel level,
			SharedWorkspaceNodeImpl parentNode) {
		this(level.getName(), level.getDescription(), level.getContextId(),
				null, parentNode);
	}

	public SharedWorkspaceLevelImpl(SharedWorkspaceLevel level,
			SharedWorkspaceLevelImpl parentLevel,
			SharedWorkspaceNodeImpl parentNode) {
		this(level.getName(), level.getDescription(), level.getContextId(),
				parentLevel, parentNode);
		for (SharedWorkspaceLevel child : level.getLevels()) {
			addLevel(new SharedWorkspaceLevelImpl(child, this));
		}
		for (SharedWorkspaceNode child : level.getNodes()) {
			addNode(new SharedWorkspaceNodeImpl(child, this));
		}
	}

	protected SharedWorkspaceLevelImpl(ContextualTextSet name,
			ContextualTextSet description, String contextId,
			SharedWorkspaceLevelImpl parentLevel,
			SharedWorkspaceNodeImpl parentNode) {
		super(name, description, contextId, parentLevel, parentNode);
	}

	@Override
	protected SharedWorkspaceNodeImpl[] buildNodeArray() {
		return new SharedWorkspaceNodeImpl[0];
	}

	@Override
	protected SharedWorkspaceLevelImpl[] buildLevelArray() {
		return new SharedWorkspaceLevelImpl[0];
	}

}
