package org.openmetadata.store.catalog.impl;

import java.util.ArrayList;

import org.openmetadata.store.catalog.SharedWorkspaceCatalog;
import org.openmetadata.store.catalog.SharedWorkspaceLevel;
import org.openmetadata.store.catalog.SharedWorkspaceNode;

public class SharedWorkspaceCatalogImpl implements SharedWorkspaceCatalog {
	
	private final ArrayList<SharedWorkspaceLevelImpl> levels;
	private final ArrayList<SharedWorkspaceNodeImpl> nodes;
	
	public SharedWorkspaceCatalogImpl() {
		levels = new ArrayList<SharedWorkspaceLevelImpl>();
		nodes = new ArrayList<SharedWorkspaceNodeImpl>();
	}
	
	public SharedWorkspaceCatalogImpl(SharedWorkspaceCatalog catalog) {
		this();
		for (SharedWorkspaceLevel level : catalog.getLevels()) {
			levels.add(new SharedWorkspaceLevelImpl(level));
		}
		for (SharedWorkspaceNode node : catalog.getNodes()) {
			nodes.add(new SharedWorkspaceNodeImpl(node));
		}
	}
	
	@Override
	public SharedWorkspaceLevelImpl[] getLevels() {
		return levels.toArray(new SharedWorkspaceLevelImpl[0]);
	}

	@Override
	public SharedWorkspaceNodeImpl[] getNodes() {
		return nodes.toArray(new SharedWorkspaceNodeImpl[0]);
	}
	
	public void addLevel(SharedWorkspaceLevel level) {
		levels.add(new SharedWorkspaceLevelImpl(level));
	}
	
	public void addNode(SharedWorkspaceNode node) {
		nodes.add(new SharedWorkspaceNodeImpl(node));
	}

}
