package org.openmetadata.store.catalog.impl;

import org.openmetadata.beans.IdentifiableBean;
import org.openmetadata.store.catalog.SharedWorkspaceNode;
import org.openmetadata.text.ContextualTextSet;

public abstract class ASharedWorkspaceNodeImpl<N extends ASharedWorkspaceNodeImpl<N, L>, L extends ASharedWorkspaceLevelImpl<N, L>>
		extends ANodeImpl<N, L> implements SharedWorkspaceNode {

	protected ASharedWorkspaceNodeImpl(String id,
			Class<? extends IdentifiableBean> type, ContextualTextSet name,
			ContextualTextSet description, String contextId, L parentLevel, N parentNode) {
		super(id, type, name, description, contextId, parentLevel, parentNode);
	}
	
	protected ASharedWorkspaceNodeImpl(String id,
			String typeName, ContextualTextSet name,
			ContextualTextSet description, String contextId, L parentLevel, N parentNode) {
		super(id, typeName, name, description, contextId, parentLevel, parentNode);
	}

	private ChangeState saveState;
	private boolean canLock;
	private boolean isLocked;
	private boolean isLocal;
	
	@Override
	public ChangeState getSaveState() {
		return saveState;
	}

	@Override
	public void setSaveState(ChangeState saveState) {
		this.saveState = saveState;
	}
	
	@Override
	public boolean canLock() {
		return canLock;
	}

	@Override
	public void setCanLock(boolean canLock) {
		this.canLock = canLock;
	}

	@Override
	public boolean isLockedByLocal() {
		return isLocked && isLocal;
	}
	
	@Override
	public boolean isLockedByOther() {
		return isLocked && !isLocal;
	}

	@Override
	public void setIsLocked(boolean isLocked, boolean isLocal) {
		this.isLocked = isLocked;
		this.isLocal = isLocal;
	}

}
