package org.openmetadata.store.catalog.impl;

import org.openmetadata.beans.IdentifiableBean;
import org.openmetadata.store.catalog.Level;
import org.openmetadata.store.catalog.Node;
import org.openmetadata.text.ContextualTextSet;

public abstract class ANodeImpl<N extends Node, L extends Level> extends
		ACatalogItemImpl<N, L> implements Node {

	private final String id;
	private final Class<? extends IdentifiableBean> type;

	protected ANodeImpl(String id, Class<? extends IdentifiableBean> type,
			ContextualTextSet name, ContextualTextSet description,
			String contextId, L parentLevel, N parentNode) {
		super(name, description, contextId, parentLevel, parentNode);
		this.id = id;
		this.type = type;
	}

	@SuppressWarnings("unchecked")
	protected ANodeImpl(String id, String typeName, ContextualTextSet name,
			ContextualTextSet description, String contextId, L parentLevel,
			N parentNode) {
		super(name, description, contextId, parentLevel, parentNode);
		this.id = id;
		Class<? extends IdentifiableBean> typeClass = null;
		try {
			typeClass = (Class<? extends IdentifiableBean>) Class
					.forName(typeName);
		} catch (ClassNotFoundException e) {
		}
		type = typeClass;
	}

	@Override
	public String getPrimaryIdentifier() {
		return id;
	}

	@Override
	public Class<? extends IdentifiableBean> getType() {
		return type;
	}

}
