package org.openmetadata.store.catalog.impl;

import org.openmetadata.beans.IdentifiableBean;
import org.openmetadata.store.catalog.ClientWorkspaceNode;
import org.openmetadata.text.ContextualTextSet;

public abstract class AClientWorkspaceNodeImpl<N extends AClientWorkspaceNodeImpl<N, L>, L extends AClientWorkspaceLevelImpl<N, L>>
		extends ASharedWorkspaceNodeImpl<N, L> implements ClientWorkspaceNode {

	protected AClientWorkspaceNodeImpl(String id,
			Class<? extends IdentifiableBean> type, ContextualTextSet name,
			ContextualTextSet description, String contextId, L parentLevel, N parentNode) {
		super(id, type, name, description, contextId, parentLevel, parentNode);
	}

	protected AClientWorkspaceNodeImpl(String id,
			String typeName, ContextualTextSet name,
			ContextualTextSet description, String contextId, L parentLevel, N parentNode) {
		super(id, typeName, name, description, contextId, parentLevel, parentNode);
	}
	
	private ChangeState commitState;
	private boolean isShared;
	private boolean isOffline;

	@Override
	public boolean isShared() {
		return isShared;
	}

	public void setIsShared(boolean isShared) {
		this.isShared = isShared;
	}
	
	@Override
	public boolean isAvailableOffline() {
		return isOffline;
	}
	
	public void setIsAvailableOffline(boolean isOffline) {
		this.isOffline = isOffline;
	}
	
	@Override
	public ChangeState getCommitState() {
		return commitState;
	}

	public void setCommitState(ChangeState commitState) {
		this.commitState = commitState;
	}

}
