package org.openmetadata.store.catalog.impl;

import java.util.ArrayList;

import org.openmetadata.store.catalog.CatalogItem;
import org.openmetadata.store.catalog.Level;
import org.openmetadata.store.catalog.Node;
import org.openmetadata.text.ContextualTextSet;

public abstract class ACatalogItemImpl<N extends Node, L extends Level> implements CatalogItem {
	
	private final L parentLevel;
	private final N parentNode;
	private final boolean isContext;
	private final String contextId;
	private final ContextualTextSet name;
	private final ContextualTextSet documentation;
	private final ArrayList<N> nodes;
	private final ArrayList<L> levels;
	
	protected ACatalogItemImpl(ContextualTextSet name, ContextualTextSet documentation, String contextId, L parentLevel, N parentNode) {
		this.name = name;
		this.documentation = documentation;
		this.contextId = contextId;
		this.isContext = contextId!=null;
		this.parentLevel = parentLevel;
		this.parentNode = parentNode;
		nodes = new ArrayList<N>();
		levels = new ArrayList<L>();
	}

	@Override
	public boolean isContext() {
		return isContext;
	}
	
	@Override
	public String getContextId() {
		return contextId;
	}
	
	@Override
	public ContextualTextSet getName() {
		return name;
	}
	
	@Override
	public ContextualTextSet getDescription() {
		return documentation;
	}
	
	@Override
	public N[] getNodes() {
		return nodes.toArray(buildNodeArray());
	}

	@Override
	public L[] getLevels() {
		return levels.toArray(buildLevelArray());
	}

	@Override
	public boolean hasParentNode() {
		return parentNode != null;
	}

	@Override
	public N getParentNode() {
		return parentNode;
	}

	@Override
	public boolean hasParentLevel() {
		return parentLevel != null;
	}

	@Override
	public L getParentLevel() {
		return parentLevel;
	}
	
	protected void addNode(N node) {
		nodes.add(node);
	}
	
	protected void addLevel(L level) {
		levels.add(level);
	}
	
	protected abstract N[] buildNodeArray();

	protected abstract L[] buildLevelArray();
	
}
