package org.openmetadata.store.catalog;

import org.openmetadata.beans.IdentifiableBean;
import org.openmetadata.store.Workspace;

/**
 * This is a specialized {@link Node} that represents an
 * {@link IdentifiableBean} object in a {@link Workspace}.
 * 
 * @author Jack Gager
 *
 */
public interface WorkspaceNode extends Node{

	public enum ChangeState {
		ADDED, DELETED, NONE, UPDATED
	};
		
	@Override
	public WorkspaceLevel[] getLevels();

	@Override
	public WorkspaceNode[] getNodes();
	
	@Override
	public WorkspaceLevel getParentLevel();
	
	@Override
	public WorkspaceNode getParentNode();

	/**
	 * Indicates whether there are unsaved changes to the
	 * <code>IdentifiableBean</code> represented by the node.
	 * 
	 * @return <code>NONE</code> if the node is unchanged, or one of
	 *         <code>ADDED</code>, <code>DELETED</code>, or <code>UPDATED</code>
	 *         depending on the type of unsaved change to the
	 *         <code>IdentifiableBean</code> represented by the node.
	 */
	public ChangeState getSaveState();
	
	public void setSaveState(ChangeState saveState);
	
}
