package org.openmetadata.store.catalog;


/**
 * This is a specialized {@link Node} in a catalog which may have contents from
 * a shared repository. It adds additional details and methods for working
 * specifically which shared repository objects.
 * 
 * @author Jack Gager
 * 
 */
public interface SharedWorkspaceNode extends WorkspaceNode {

	@Override
	public SharedWorkspaceLevel[] getLevels();

	@Override
	public SharedWorkspaceNode[] getNodes();

	@Override
	public SharedWorkspaceLevel getParentLevel();

	@Override
	public SharedWorkspaceNode getParentNode();

	/**
	 * Indicates whether the node can be locked for editing.
	 * 
	 * @return <code>true</code> if the node can be locked
	 */
	public boolean canLock();

	/**
	 * Indicates whether the node is locked for editing.
	 * 
	 * @return <code>true</code> if the node is locked
	 */
	public boolean isLockedByLocal();

	/**
	 * Indicates whether the node is locked for editing.
	 * 
	 * @return <code>true</code> if the node is locked
	 */
	public boolean isLockedByOther();
	
	public void setCanLock(boolean canLock);
	
	public void setIsLocked(boolean isLocked, boolean isLocal);
	
}
