package org.openmetadata.store.catalog;

import org.openmetadata.beans.IdentifiableBean;
import org.openmetadata.store.Store;

/**
 * This is a specialized {@link CatalogItem} in a catalog which represents an
 * {@link IdentifiableBean} object in a {@link Store}. It may contain additional
 * grouping {@link Level}s or child <code>Node</code>s.
 * 
 * @author Jack Gager
 * 
 */
public interface Node extends CatalogItem {

	/**
	 * Gets the primary identifier of the <code>IdentifiableBean</code> which is
	 * represented by this node. This object must be accessible from the
	 * {@link Store#getBean(Class, String) Store.getBean} method.
	 * 
	 * @return the identifier of the bean represented by this <code>Node</code>
	 */
	public String getPrimaryIdentifier();
	
	/**
	 * Gets the subclass of <code>IdentifiableBean</code> for the bean which is
	 * represented by this node. The value from this can be used as the
	 * <code>Class</code> parameter for the {@link Store#getBean(Class, String)
	 * Store.getBean} method.
	 * 
	 * @return the subclass of <code>IdentifiableBean</code> for the bean
	 *         represented by this <code>Node</code>
	 */
	public Class<? extends IdentifiableBean> getType();
	
}
