package org.openmetadata.store.catalog;

import org.openmetadata.store.repository.ClientWorkspaceRepository;

/**
 * This is a specialized {@link Node} in a catalog which may have contents from
 * a shared repository. It adds additional details and methods for working
 * specifically which shared repository objects.
 * 
 * @author Jack Gager
 * 
 */
public interface ClientWorkspaceNode extends SharedWorkspaceNode {

	@Override
	public ClientWorkspaceLevel[] getLevels();

	@Override
	public ClientWorkspaceNode[] getNodes();

	@Override
	public ClientWorkspaceLevel getParentLevel();

	@Override
	public ClientWorkspaceNode getParentNode();

	/**
	 * Indicates whether the node comes from a shared repository (i.e. the
	 * repository which provides it is a {@link ClientWorkspaceRepository}.
	 * 
	 * @return <code>true</code> if the node is shared
	 */
	public boolean isShared();

	/**
	 * Indicates whether a shared node ({@link #isShared()}) is available when
	 * the repository is off line.
	 * 
	 * @return <code>true</code> if the shared node is available off line (i.e.
	 *         is has been cached locally), <code>false</code> otherwise
	 */
	public boolean isAvailableOffline();

	/**
	 * Indicates whether there are uncommitted changes to the
	 * <code>IdentifiableBean</code> represented by the node. This is only
	 * applicable is {@link #isShared()} is <code>true</code>.
	 * 
	 * @return <code>NONE</code> if the node is unchanged, or one of
	 *         <code>ADDED</code>, <code>DELETED</code>, or <code>UPDATED</code>
	 *         depending on the type of unsaved change to the
	 *         <code>IdentifiableBean</code> represented by the node.
	 */
	public ChangeState getCommitState();

}
