package org.openmetadata.store.catalog;

import org.openmetadata.beans.IdentifiableBean;
import org.openmetadata.store.Store;

/**
 * Provides a {@link Catalog} detailing the {@link IdentifiableBean}s available
 * in a {@link Store}.
 * <p>
 * Implementations of this will typically be paired with a <code>Store</code>.
 * 
 * @author Jack Gager
 * 
 */
public interface CatalogProvider {

	/**
	 * Gets the <code>Catalog</code> of <code>IdentifiableBean</code> objects
	 * contained in a <code>Store</code>.
	 * 
	 * @return a <code>Catalog</code> of store contents
	 */
	public Catalog getCatalog();

}
