package org.openmetadata.store.catalog;

import org.openmetadata.beans.IdentifiableBean;
import org.openmetadata.store.Store;

/**
 * This contains a collection of {@link IdentifiableBean}s which can be accessed
 * from a {@link Store}. The beans are represented by {@link Node}s, which can
 * be arranged hierarchically. The beans can also be grouped into {@link Level}
 * s, which represent groupings not associated with a bean from the
 * <code>Store</code>.
 * <p>
 * The <code>Catalog</code> does not necessarily have to detail every object in
 * the <code>Store</code>. Typically, the <code>Catalog</code> will contain only
 * the objects which can serve as context objects (i.e. those which can be
 * modified and saved directly).
 * 
 * @author Jack Gager
 * 
 * @see ContextManager
 * 
 */
public interface Catalog {

	/**
	 * Gets the root level groups of the catalog.
	 * 
	 * @return the root group <code>Level</code>s
	 */
	public Level[] getLevels();

	/**
	 * Gets the root level beans of the catalog.
	 * 
	 * @return the root level bean <code>Node</code>s
	 */
	public Node[] getNodes();

}
