package org.openmetadata.store.cache.impl;

import org.openmetadata.beans.IdentifiableBean;
import org.openmetadata.cache.impl.SoftLockingCache;
import org.openmetadata.store.cache.LockingBeanCache;

/**
 * A {@link SofLockingCache} implementation for {@link IdentifiableBean}s.
 * 
 * @author Jack Gager
 */
public class SoftLockingBeanCache extends SoftLockingCache<IdentifiableBean> implements LockingBeanCache {

	@Override
	public IdentifiableBean tryAdd(IdentifiableBean bean) {
		String id = extractId(bean);
		if (contains(id)) {
			return get(id);
		}
		add(bean);
		return bean;
	}
	
	@Override
	protected String extractId(IdentifiableBean object) {
		return object.getPrimaryIdentifier();
	}

}
