package org.openmetadata.store.cache.impl;

import org.openmetadata.beans.IdentifiableBean;
import org.openmetadata.cache.impl.SoftCache;
import org.openmetadata.store.cache.BeanCache;

/**
 * A {@link SoftCache} implementation for {@link IdentifiableBean}s.
 * 
 * @author Jack Gager
 */
public class SoftBeanCache extends SoftCache<IdentifiableBean> implements BeanCache {
	
	@Override
	public IdentifiableBean tryAdd(IdentifiableBean bean) {
		String id = extractId(bean);
		if (contains(id)) {
			return get(id);
		}
		add(bean);
		return bean;
	}
	
	@Override
	protected String extractId(IdentifiableBean object) {
		return object.getPrimaryIdentifier();
	}
}
