package org.openmetadata.store.cache;

import org.openmetadata.beans.IdentifiableBean;
import org.openmetadata.cache.Cache;

/**
 * A locking cache of {@link IdentifiableBean} objects.
 * 
 * @author Jack Gager
 */
public interface BeanCache extends Cache<IdentifiableBean> {

	/**
	 * Attempts to add a new bean to the cache, but only if it does not already
	 * exist. If the bean does exist, the existing instance should be returned.
	 * Callers of this method should take this return into account.
	 * 
	 * @param bean
	 *            the bean to be added
	 * @return the added bean, or the previously cached bean if this already
	 *         existed
	 */
	public IdentifiableBean tryAdd(IdentifiableBean bean);

}
