package org.openmetadata.store.access.impl;

import java.util.Calendar;

import org.openmetadata.store.access.LockInformation;
import org.openmetadata.store.access.User;

public class Unlocked implements LockInformation {

	private final String id;

	public Unlocked(String id) {
		this.id = id;
	}

	@Override
	public String getPrimaryIdentifier() {
		return id;
	}

	@Override
	public User getUser() {
		return null;
	}

	@Override
	public Calendar getLockTime() {
		return Calendar.getInstance();
	}

	@Override
	public boolean hasExpirationTime() {
		return false;
	}

	@Override
	public Calendar getExpirationTime() {
		return null;
	}
	
	@Override
	public boolean isLocked() {
		return false;
	}

	@Override
	public LockInformation[] getChildLocks() {
		return new LockInformation[] {};
	}

	@Override
	public LockInformation getParentLock() {
		return null;
	}

	@Override
	public boolean hasParentLock() {
		return false;
	}

}
