package org.openmetadata.store.access.impl;

import java.util.Calendar;

import org.openmetadata.store.access.LockInformation;
import org.openmetadata.store.access.User;

public class Locked implements LockInformation {

	private final String id;
	private final User user;
	private final Calendar lockTime;
	private final Calendar expirationTime;
	private final LockInformation[] children;
	private LockInformation parent;

	public Locked(String id, User user, Calendar lockTime) {
		this(id, user, lockTime, null, new Locked[] {});
	}

	public Locked(String id, User user, Calendar lockTime,
			Calendar expirationTime) {
		this(id, user, lockTime, expirationTime, new Locked[] {});
	}

	public Locked(String id, User user, Calendar lockTime,
			Locked... children) {
		this(id, user, lockTime, null, children);
	}

	public Locked(String id, User user, Calendar lockTime,
			Calendar expirationTime, Locked... children) {
		this.id = id;
		this.user = user;
		this.lockTime = lockTime;
		this.expirationTime = expirationTime;
		this.children = children;
		for (Locked child : children) {
			if (!child.getUser().equals(user)) {
				throw new IllegalArgumentException(
						"Cannot nest locks for differnt users.");
			}
			child.setParent(this);
		}
	}

	@Override
	public String getPrimaryIdentifier() {
		return id;
	}

	@Override
	public User getUser() {
		return user;
	}

	@Override
	public Calendar getLockTime() {
		return lockTime;
	}

	@Override
	public boolean hasExpirationTime() {
		return expirationTime != null;
	}

	@Override
	public Calendar getExpirationTime() {
		return expirationTime;
	}

	@Override
	public boolean isLocked() {
		return true;
	}

	@Override
	public LockInformation[] getChildLocks() {
		return children;
	}

	@Override
	public LockInformation getParentLock() {
		return parent;
	}

	@Override
	public boolean hasParentLock() {
		return parent != null;
	}

	private void setParent(Locked parent) {
		this.parent = parent;
	}

}
