package org.openmetadata.store.access;

public class User {
	
	private final String id;
	private final String location;
	private final String name;
	
	public User(String id, String location, String name) {
		if (null == id || null == location || null == name) {
			throw new IllegalArgumentException("Values cannot be null");
		}
		this.id = id;
		this.location = location;
		this.name = name;
	}

	public String getId() {
		return id;
	}

	public String getLocation() {
		return location;
	}

	public String getName() {
		return name;
	}
	
	@Override
	public int hashCode() {
		return id.toLowerCase().hashCode() + location.toLowerCase().hashCode();
	}
	
	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}
		if (obj == null || !(obj instanceof User)) {
			return false;
		}
		User user = (User) obj;
		return this.id.equalsIgnoreCase(user.getId()) && this.location.equalsIgnoreCase(user.getLocation());
	}
	
}
