package org.openmetadata.store.access;

/**
 * Details the access rights for a type or instance of an
 * {@link IdentifiableBean}. These define the possible actions that a user may
 * take on a given type of bean for which these rights are returned.
 * <p>
 * When this pertains to a type, the access rights may be superseded by those
 * for a particular instance of a bean of the same type.
 * 
 * @author Jack Gager
 * 
 */
public interface AccessRights {

	/**
	 * Indicates whether the type or bean can be viewed by a user.
	 * 
	 * @return <code>true</code> if the type or bean can be viewed
	 */
	public boolean canVeiw();

	/**
	 * Indicates whether the type or bean can be edited by a user.
	 * 
	 * @return <code>true</code> if the type or bean can be edited
	 */
	public boolean canEdit();

	/**
	 * Indicates whether new instances of a bean type can be created by a user.
	 * This is only applicable for access rights for a type.
	 * 
	 * @return <code>true</code> if new instances of the type can be created.
	 */
	public boolean canCreate();

	/**
	 * Indicates whether the type or bean can be deleted by a user.
	 * 
	 * @return <code>true</code> if the type or bean can be deleted
	 */
	public boolean canDelete();

}
