package org.openmetadata.store;

import org.openmetadata.store.catalog.WorkspaceCatalogProvider;
import org.openmetadata.store.catalog.WorkspaceNode;

/**
 * This allows for the segmenting of {@link Workspace}s based on users and/or
 * the object being edited. A catalog is provided which details the objects
 * available for editing. When an object is selected from this catalog, the node
 * from which it was selected can be used in concert with a user identification
 * to retrieve a workspace instance for working with the object (and the objects
 * associated with it). In this context, a user can be anything from an actual
 * person to an application utilizing a workspace.
 * <p>
 * This is used when it is necessary to isolate the changes in one workspace
 * from those in another until a time that the workspace chooses to promote
 * them. The nature of this is flexible so that the point when the changes are
 * promoted are dictated by the workspace implementation.
 * 
 * @author Jack Gager
 * 
 */
public interface WorkspaceProvider extends StoreProvider, WorkspaceCatalogProvider {
	
	public Workspace getWorkspace(WorkspaceNode node);
	
	public Workspace getDefaultWorkspace();
	
}
