package org.openmetadata.store;

import org.openmetadata.store.access.LockInformation;
import org.openmetadata.store.change.ChangeSet;
import org.openmetadata.store.change.ContextChanges;
import org.openmetadata.store.exceptions.StoreException;
import org.openmetadata.store.managers.ContextManager;

/**
TODO: Update all documentation
 * An interface for interacting with shared repository of {@link IdentiableBean}
 * objects. Implementations will typically be paired with a {@link Workspace},
 * from which beans can be retrieved and edited.
 * <p>
 * Instances of this are associated with a single user of the shared repository.
 * Therefore, the methods do not have user information associated with them.
 * Instead, these methods are implied to be return the information for the user
 * associated with the instance.
 * <p>
 * As with a <code>Workspace</code>, the objects from the repository can be
 * managed within the context of another object. The central repository
 * expresses this contextual information through the hierarchical nature of the
 * {@link LockInformation}. When locking an object, multiple child objects may
 * be locked as well. This indicates that committing changes to the locked
 * object will result in any changes to the child object being committed as
 * well. This information will effectively feed into the {@link ContextManager}
 * of the associated workspace.
 * 
 * @author Jack Gager
 * 
 */
public interface ClientWorkspace extends SharedWorkspace {

	/**
	 * TODO: Update all documentation
	 * 
	 * Returns the set of changes within the context of the objects locked by
	 * this client which have not been committed to the central repository. The
	 * context objects ({@link ContextChanges#getContextId()}) within the set
	 * will only be those objects which were explicitly locked by the client
	 * which have been modified but not committed to the repository.
	 * 
	 * @return a <code>Set</code> of <code>ContextChanges</code> detailing the
	 *         uncommitted changes (additions, updates, and deletions) for all
	 *         root level locked objects.
	 * @see ContextChanges
	 */
	public ChangeSet<String> getUncommittedChange();
	
	// TODO Exception needs to be more explicit for save (e.g. AccessRightsException, ValidationException)
	
	/**
	 * Commits the changes to the specified object and all of the objects within
	 * its context to the repository. Only explicitly locked objects (i.e.
	 * objects with <code>LockInformation</code> where the
	 * {@link LockInformation#hasParentLock() hasParentLock} method returns
	 * <code>false</code> may be committed.
	 * 
	 * @param id
	 *            the identifier of the object which is to be committed to the
	 *            repository
	 * @throws StoreException
	 *             if the commitment of the changes resulted in a recoverable
	 *             error, such as the repository rejecting the changes
	 */
	public void commitChanges(String id) throws StoreException;
	
	public void commitAllChanges() throws StoreException;
	
	/**
	 * Reverts the changes to the specified object and all of the objects within
	 * its context to the information from the shared repository. Only
	 * explicitly locked objects (i.e. objects with <code>LockInformation</code>
	 * where the {@link LockInformation#hasParentLock() hasParentLock} method
	 * returns <code>false</code> may be reverted.
	 * 
	 * @param id
	 *            the identifier of the object which is to be reverted to the
	 *            information from the repository
	 */
	public void revertChanges(String id);
	
	public void revertAllChanges();
	
}