/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.store.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openmetadata.beans.IdentifiableBean;
import org.openmetadata.beans.deserialization.Deserializer;
import org.openmetadata.beans.exceptions.ResolverException;
import org.openmetadata.beans.paging.Paginator;
import org.openmetadata.beans.paging.impl.PaginatorImpl;
import org.openmetadata.beans.reference.Resolver;
import org.openmetadata.store.Store;
import org.openmetadata.store.access.AccessRights;
import org.openmetadata.store.cache.BeanCache;
import org.openmetadata.store.exceptions.InsufficientRightsException;
import org.openmetadata.store.exceptions.InvalidCriteriaException;
import org.openmetadata.store.exceptions.ObjectNotFoundException;
import org.openmetadata.store.managers.AccessManager;
import org.openmetadata.store.query.Criteria;
import org.openmetadata.store.query.Result;
import org.openmetadata.store.query.SearchResult;
import org.openmetadata.store.query.impl.CriteriaImpl;
import org.openmetadata.store.repository.StoreRepository;

public class StoreImpl<Source>
implements Store,
Resolver {
    protected Log logger = LogFactory.getLog(this.getClass());
    private final String contextId;
    private BeanCache beanCache;
    private StoreRepository<Source> storeRepository;
    private Deserializer<Source> deserializer;
    private boolean isCaching;
    private final boolean mustCache;

    public StoreImpl(String contextId) {
        this(contextId, false);
    }

    public StoreImpl(String contextId, boolean mustCache) {
        this.contextId = contextId;
        this.mustCache = mustCache;
    }

    @Override
    public <B extends IdentifiableBean> B getBean(Class<B> beanClass, String id) throws ObjectNotFoundException, InsufficientRightsException {
        this.logger.debug((Object)("Getting bean of type: " + beanClass.getCanonicalName() + ", with id: " + id + "."));
        B bean = this._getBean(beanClass, id);
        AccessRights rights = this.getAccessManager().getRights((IdentifiableBean)bean);
        if (!rights.canVeiw()) {
            this.logger.debug((Object)"User could not view requested object");
            throw new InsufficientRightsException(rights);
        }
        return bean;
    }

    @Override
    public <B extends IdentifiableBean> Paginator<B> query(Class<B> beanClass, Criteria<B> criteria) throws InvalidCriteriaException {
        SearchResult results = this.getStoreRepository().query(this.getContextId(), criteria);
        ArrayList<String> resultIds = new ArrayList<String>();
        for (Result result : results.getResults()) {
            resultIds.add(result.getIdentifier());
        }
        return new PaginatorImpl(beanClass, (Resolver)this, criteria.getPageSize(), results.isComplete(), resultIds.toArray(new String[0]));
    }

    public <B extends IdentifiableBean> B resolve(Class<B> beanClass, String id) throws ResolverException {
        this.logger.debug((Object)("Resolving bean: " + id + "."));
        try {
            return this._getBean(beanClass, id);
        }
        catch (ObjectNotFoundException onfe) {
            throw new ResolverException(onfe.getPrimaryIdentifiers());
        }
    }

    public <B extends IdentifiableBean> Set<B> resolve(Class<B> beanClass, Set<String> ids) throws ResolverException {
        B bean;
        this.logger.debug((Object)("Resolving beans: " + ids + "."));
        HashSet<IdentifiableBean> beanSet = new HashSet<IdentifiableBean>();
        HashSet<String> nonCacheSet = new HashSet<String>();
        HashMap<String, B> beanMap = new HashMap<String, B>();
        for (String id : ids) {
            if ((this.mustCache || this.isCaching) && this.getBeanCache().contains(id)) {
                this.logger.debug((Object)("Found bean: " + id + ", in cache."));
                bean = this.castBean(beanClass, this.getBeanCache().get(id));
                assert (bean != null);
                beanMap.put(bean.getPrimaryIdentifier(), bean);
                continue;
            }
            nonCacheSet.add(id);
        }
        this.logger.debug((Object)("Getting beans: " + nonCacheSet + ", from BeanRepository."));
        try {
            for (Object source : this.getStoreRepository().get(nonCacheSet)) {
                bean = this.deserializeSource(beanClass, source);
                beanMap.put(bean.getPrimaryIdentifier(), bean);
                if (!this.mustCache() && !this.isCaching()) continue;
                this.getBeanCache().add(bean);
            }
        }
        catch (ObjectNotFoundException onfe) {
            throw new ResolverException(onfe.getPrimaryIdentifiers());
        }
        this.logger.debug((Object)"Ordering results.");
        for (String id : ids) {
            if (!beanMap.containsKey(id)) continue;
            beanSet.add((IdentifiableBean)beanMap.get(id));
        }
        return beanSet;
    }

    public Set<String> getReferrers(String id) {
        this.logger.debug((Object)("Retrieving referrers for: " + id + "."));
        CriteriaImpl<IdentifiableBean> criteria = new CriteriaImpl<IdentifiableBean>(IdentifiableBean.class);
        HashSet<String> references = new HashSet<String>();
        references.add(id);
        criteria.setReferencesDirect(true);
        criteria.addReference(references);
        try {
            SearchResult results = this.getStoreRepository().query(this.getContextId(), criteria);
            LinkedHashSet<String> resultIds = new LinkedHashSet<String>();
            for (Result result : results.getResults()) {
                resultIds.add(result.getIdentifier());
            }
            return resultIds;
        }
        catch (InvalidCriteriaException e) {
            throw this.raiseRuntimeException("Could not retrieve referrers.", e);
        }
    }

    public void setBeanCache(BeanCache beanCache) {
        if (this.beanCache != null && !this.beanCache.equals(beanCache)) {
            throw this.raiseRuntimeException("BeanCache cannot be reset.");
        }
        this.beanCache = beanCache;
        this.isCaching = true;
    }

    public void setStoreRepository(StoreRepository<Source> storeRepository) {
        if (this.storeRepository != null && !this.storeRepository.equals(storeRepository)) {
            throw this.raiseRuntimeException("StoreRepository cannot be reset.");
        }
        this.storeRepository = storeRepository;
    }

    protected final AccessManager getAccessManager() {
        return this.getStoreRepository().getAccessManager();
    }

    protected final BeanCache getBeanCache() {
        if (this.beanCache == null) {
            throw this.raiseRuntimeException("BeanCache is not set.");
        }
        return this.beanCache;
    }

    protected final StoreRepository<Source> getStoreRepository() {
        if (this.storeRepository == null) {
            throw this.raiseRuntimeException("StoreRepository is not set.");
        }
        return this.storeRepository;
    }

    protected final Deserializer<Source> getDeserializer() {
        if (this.deserializer == null && this.getStoreRepository().mustDeserialize()) {
            this.initializeDeserializer(this.getStoreRepository().getDeserializer());
        }
        return this.deserializer;
    }

    protected final void initializeDeserializer(Deserializer<Source> deserializer) {
        if (deserializer == null) {
            throw this.raiseRuntimeException("Deserializer cannot be null.");
        }
        if (this.deserializer != null && !this.deserializer.equals(deserializer)) {
            throw this.raiseRuntimeException("Deserializer cannot be reset.");
        }
        this.deserializer = deserializer;
        this.logger.debug((Object)"Settting Store as Resolver of Deserializer");
        deserializer.setResolver((Resolver)this);
    }

    protected final String getContextId() {
        return this.contextId;
    }

    protected final boolean mustCache() {
        return this.mustCache;
    }

    protected final boolean isCaching() {
        return this.isCaching;
    }

    protected <B extends IdentifiableBean> B _getBean(Class<B> beanClass, String id) throws ObjectNotFoundException {
        B bean;
        if ((this.mustCache() || this.isCaching()) && this.getBeanCache().contains(id)) {
            this.logger.debug((Object)"Returning object from cache.");
            bean = this.castBean(beanClass, this.getBeanCache().get(id));
        } else {
            this.logger.debug((Object)"Retrieving object from bean repository.");
            bean = this.deserializeSource(beanClass, this.getStoreRepository().get(id));
            if (this.mustCache() || this.isCaching()) {
                this.getBeanCache().add(bean);
            }
        }
        assert (bean != null);
        return bean;
    }

    protected IdentifiableBean getRootContainer(String id) {
        try {
            IdentifiableBean bean = this._getBean(IdentifiableBean.class, id);
            if (bean.getContainerIdentifier().equals(bean.getPrimaryIdentifier())) {
                return bean;
            }
            return this.getRootContainer(bean.getContainerIdentifier());
        }
        catch (ObjectNotFoundException e) {
            throw this.raiseRuntimeException("Could not find container bean.", e);
        }
    }

    protected final <B extends IdentifiableBean> B deserializeSource(Class<B> beanClass, Source source) {
        this.logger.debug((Object)("Deserializing source: " + source.toString()));
        if (this.getStoreRepository().mustDeserialize()) {
            return (B)this.getDeserializer().deserialize(beanClass, source);
        }
        return this.castBean(beanClass, source);
    }

    protected final RuntimeException raiseRuntimeException(String message) {
        this.logger.error((Object)message);
        return new RuntimeException(message);
    }

    protected final RuntimeException raiseRuntimeException(String message, Throwable exception) {
        this.logger.error((Object)message, exception);
        return new RuntimeException(message, exception);
    }

    protected final <B extends IdentifiableBean> B castBean(Class<B> beanClass, Object bean) {
        if (!beanClass.isAssignableFrom(bean.getClass())) {
            throw this.raiseRuntimeException("The bean of type, " + bean.getClass().getCanonicalName() + ", cannot be converted to the type, " + beanClass.getCanonicalName() + ".");
        }
        return (B)((IdentifiableBean)beanClass.cast(bean));
    }
}

