/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.store.managers;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WorkspaceReferenceManager {
    private HashSet<String> deletedReferrers;
    private HashMap<String, Set<String>> referenceAdditions;
    private HashMap<String, Set<String>> referenceSubtractions;
    private HashMap<String, Set<String>> referrerAdditions;
    private HashMap<String, Set<String>> referrerSubtractions;
    protected Log logger = LogFactory.getLog(this.getClass());

    public WorkspaceReferenceManager() {
        this.deletedReferrers = new HashSet();
        this.referenceAdditions = new HashMap();
        this.referenceSubtractions = new HashMap();
        this.referrerAdditions = new HashMap();
        this.referrerSubtractions = new HashMap();
    }

    public Set<String> getReferenceAdditions(String id) {
        return this.getSet(this.referenceAdditions, id);
    }

    public Set<String> getReferenceSubtractions(String id) {
        return this.getSet(this.referenceSubtractions, id);
    }

    public Set<String> getReferrerAdditions(String id) {
        return this.getSet(this.referrerAdditions, id);
    }

    public Set<String> getReferrerSubtractions(String id) {
        return this.getSet(this.referrerSubtractions, id);
    }

    public Set<String> getDeletedReferrers() {
        HashSet<String> returnSet = new HashSet<String>();
        returnSet.addAll(this.deletedReferrers);
        return returnSet;
    }

    public void addReferences(String fromId, String ... toIds) {
        String[] stringArray = toIds;
        int n = toIds.length;
        int n2 = 0;
        while (n2 < n) {
            String toId = stringArray[n2];
            this.logger.debug((Object)("Adding reference from: " + fromId + ", to: " + toId + "."));
            Set<Object> additions = new HashSet();
            if (this.referenceAdditions.containsKey(fromId)) {
                additions = this.referenceAdditions.get(fromId);
            } else {
                this.referenceAdditions.put(fromId, additions);
            }
            additions.add(toId);
            additions = new HashSet();
            if (this.referrerAdditions.containsKey(toId)) {
                additions = this.referrerAdditions.get(toId);
            } else {
                this.referrerAdditions.put(toId, additions);
            }
            additions.add(fromId);
            if (this.referenceSubtractions.containsKey(fromId)) {
                this.referenceSubtractions.get(fromId).remove(toId);
            }
            if (this.referrerSubtractions.containsKey(toId)) {
                this.referrerSubtractions.get(toId).remove(fromId);
            }
            ++n2;
        }
    }

    public void removeReferences(String fromId, String ... toIds) {
        String[] stringArray = toIds;
        int n = toIds.length;
        int n2 = 0;
        while (n2 < n) {
            String toId = stringArray[n2];
            this.logger.debug((Object)("Removing reference from: " + fromId + ", to: " + toId + "."));
            Set<Object> subtractions = new HashSet();
            if (this.referenceSubtractions.containsKey(fromId)) {
                subtractions = this.referenceSubtractions.get(fromId);
            } else {
                this.referenceSubtractions.put(fromId, subtractions);
            }
            subtractions.add(toId);
            subtractions = new HashSet();
            if (this.referrerSubtractions.containsKey(toId)) {
                subtractions = this.referrerSubtractions.get(toId);
            } else {
                this.referrerSubtractions.put(toId, subtractions);
            }
            subtractions.add(fromId);
            if (this.referenceAdditions.containsKey(fromId)) {
                this.referenceAdditions.get(fromId).remove(toId);
            }
            if (this.referrerAdditions.containsKey(toId)) {
                this.referrerAdditions.get(toId).remove(fromId);
            }
            ++n2;
        }
    }

    public void addDeletedReferrer(String id) {
        this.deletedReferrers.add(id);
    }

    public void clear(String id) {
        this.logger.debug((Object)("Clearing workspace reference information for: " + id + "."));
        this.deletedReferrers.remove(id);
        if (this.referenceAdditions.containsKey(id)) {
            for (String to : this.referenceAdditions.get(id)) {
                if (!this.referrerAdditions.containsKey(to)) continue;
                this.referrerAdditions.get(to).remove(id);
            }
            this.referenceAdditions.remove(id);
        }
        if (this.referenceSubtractions.containsKey(id)) {
            for (String to : this.referenceSubtractions.get(id)) {
                if (this.referrerSubtractions.containsKey(to)) {
                    this.referrerSubtractions.get(to).remove(id);
                }
                this.referenceSubtractions.remove(id);
            }
        }
    }

    public void clearAll() {
        this.logger.debug((Object)"Clearing all workspace reference information.");
        this.deletedReferrers.clear();
        this.referenceAdditions.clear();
        this.referenceSubtractions.clear();
        this.referrerAdditions.clear();
        this.referrerSubtractions.clear();
    }

    private HashSet<String> getSet(HashMap<String, Set<String>> map, String id) {
        HashSet<String> returnSet = new HashSet<String>();
        if (map.containsKey(id)) {
            returnSet.addAll((Collection<String>)map.get(id));
        }
        return returnSet;
    }
}

