/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.store.impl;

import java.util.ArrayList;
import java.util.Set;
import org.openmetadata.beans.IdentifiableBean;
import org.openmetadata.beans.deserialization.MutableDeserializer;
import org.openmetadata.beans.factory.BeanFactory;
import org.openmetadata.beans.notification.ChangeEvent;
import org.openmetadata.beans.notification.IdentifiableChangeEvent;
import org.openmetadata.beans.notification.IdentifiableChangeListener;
import org.openmetadata.beans.reference.Resolver;
import org.openmetadata.beans.serialization.Serializer;
import org.openmetadata.store.Workspace;
import org.openmetadata.store.access.AccessRights;
import org.openmetadata.store.cache.BeanCache;
import org.openmetadata.store.cache.LockingBeanCache;
import org.openmetadata.store.change.ChangeSet;
import org.openmetadata.store.change.impl.ChangeSetImpl;
import org.openmetadata.store.exceptions.InsufficientBeanRightsException;
import org.openmetadata.store.exceptions.InsufficientRightsException;
import org.openmetadata.store.exceptions.ObjectNotFoundException;
import org.openmetadata.store.exceptions.StoreException;
import org.openmetadata.store.impl.StoreImpl;
import org.openmetadata.store.managers.AccessManager;
import org.openmetadata.store.managers.ChangeManager;
import org.openmetadata.store.managers.ChangeNotificationManager;
import org.openmetadata.store.managers.WorkspaceReferenceManager;
import org.openmetadata.store.managers.impl.ChangeNotificationManagerImpl;
import org.openmetadata.store.repository.StoreRepository;
import org.openmetadata.store.repository.WorkspaceRepository;
import org.openmetadata.store.repository.notification.SaveEvent;
import org.openmetadata.store.repository.notification.SaveListener;

public class WorkspaceImpl<Source>
extends StoreImpl<Source>
implements Workspace,
IdentifiableChangeListener,
SaveListener {
    private LockingBeanCache lockingBeanCache;
    private ChangeManager changeManager;
    private WorkspaceRepository<Source> workspaceRepository;
    private MutableDeserializer<Source> mutableDeserializer;
    private BeanFactory beanFactory;
    private ChangeNotificationManager changeNotificationManager = new ChangeNotificationManagerImpl();
    private WorkspaceReferenceManager localReferenceManager = new WorkspaceReferenceManager();
    private ArrayList<String> saveOperationList = new ArrayList();

    public WorkspaceImpl(String contextId, boolean mustDeserialize) {
        super(contextId, true);
    }

    @Override
    public <B extends IdentifiableBean> B createBean(Class<B> beanClass) throws InsufficientRightsException {
        this.logger.debug((Object)("Creating bean of type: " + beanClass.getCanonicalName() + "."));
        AccessRights rights = this.getRights(beanClass);
        if (!rights.canCreate()) {
            this.logger.debug((Object)("Could not create bean of type: " + beanClass.getCanonicalName() + "."));
            throw new InsufficientRightsException(rights);
        }
        IdentifiableBean bean = this.getBeanFactory().newInstance(beanClass);
        this.logger.debug((Object)("Created bean with id: " + bean.getPrimaryIdentifier() + "."));
        return (B)bean;
    }

    @Override
    public void discardAllChanges() {
        this.discardChanges(this.getContextId());
    }

    @Override
    public void discardChanges(String id) {
        this.logger.debug((Object)("Discarding changes for bean: " + id + "."));
        LockingBeanCache cache = this.getLockingBeanCache();
        ChangeManager changeManager = this.getChangeManager();
        ChangeSet<String> discardSet = changeManager.getDiscardSet(id);
        for (String u : discardSet.getUpdates()) {
            this.revertBean(u);
        }
        for (String d : discardSet.getDeletions()) {
            this.revertBean(d);
        }
        for (String a : changeManager.getAllDiscardItems(id).getAdditions()) {
            this.localReferenceManager.clear(a);
            if (!cache.contains(a)) continue;
            cache.release((IdentifiableBean)cache.get(a), this);
        }
        for (String d : changeManager.getAllDiscardItems(id).getDeletions()) {
            this.localReferenceManager.clear(d);
            if (!cache.contains(d)) continue;
            cache.release((IdentifiableBean)cache.get(d), this);
        }
        for (String u : changeManager.getAllDiscardItems(id).getUpdates()) {
            this.localReferenceManager.clear(u);
            if (!cache.contains(u)) continue;
            cache.release((IdentifiableBean)cache.get(u), this);
        }
        changeManager.notifyDiscard(id);
    }

    @Override
    public ChangeNotificationManager getChangeNotificationManager() {
        this.logger.debug((Object)"Getting change notification manager.");
        return this.changeNotificationManager;
    }

    @Override
    public AccessRights getRights(IdentifiableBean bean) {
        this.logger.debug((Object)("Getting access right to bean: " + bean.getPrimaryIdentifier() + "."));
        return this.getAccessManager().getRights(bean);
    }

    @Override
    public AccessRights getRights(Class<? extends IdentifiableBean> beanClass) {
        this.logger.debug((Object)("Getting access right to bean class: " + beanClass.getCanonicalName() + "."));
        return this.getAccessManager().getRights(beanClass);
    }

    @Override
    public ChangeSet<String> getUnsavedChanges() {
        return this.getChangeManager().getUnsavedChanges();
    }

    @Override
    public synchronized void saveAllChanges() throws InsufficientBeanRightsException {
        this.saveChanges(this.getContextId());
    }

    @Override
    public synchronized void saveChanges(String id) throws InsufficientBeanRightsException {
        IdentifiableBean bean;
        this.logger.debug((Object)("Saving changes for bean: " + id + "."));
        LockingBeanCache cache = this.getLockingBeanCache();
        ChangeManager changeManager = this.getChangeManager();
        ChangeSet<String> saveSet = changeManager.getSaveSet(id);
        ChangeSetImpl changeSet = new ChangeSetImpl();
        AccessManager accessManager = this.getAccessManager();
        for (String a : saveSet.getAdditions()) {
            bean = (IdentifiableBean)cache.get(a);
            if (accessManager.getRights(bean.getBeanType()).canCreate()) {
                changeSet.getAdditions().add(this.serializeBean(bean));
                continue;
            }
            throw new RuntimeException("Access rights violation; cannot create " + bean.getBeanType());
        }
        for (String u : saveSet.getUpdates()) {
            bean = (IdentifiableBean)cache.get(u);
            if (accessManager.getRights(bean).canEdit()) {
                changeSet.getUpdates().add(this.serializeBean(bean));
                continue;
            }
            throw new RuntimeException("Access rights violation; cannot edit " + bean.getPrimaryIdentifier());
        }
        for (String d : saveSet.getDeletions()) {
            bean = (IdentifiableBean)cache.get(d);
            if (accessManager.getRights(bean.getBeanType()).canDelete()) {
                changeSet.getDeletions().add(this.serializeBean(bean));
                continue;
            }
            throw new RuntimeException("Access rights violation; cannot delete " + bean.getBeanType());
        }
        this.performSave(id, changeSet);
        for (String a : changeManager.getAllSaveItems(id).getAdditions()) {
            this.localReferenceManager.clear(a);
            if (!cache.contains(a)) continue;
            cache.release((IdentifiableBean)cache.get(a), this);
        }
        for (String d : changeManager.getAllSaveItems(id).getDeletions()) {
            this.localReferenceManager.clear(d);
            if (!cache.contains(d)) continue;
            cache.release((IdentifiableBean)cache.get(d), this);
        }
        for (String u : changeManager.getAllSaveItems(id).getUpdates()) {
            this.localReferenceManager.clear(u);
            if (!cache.contains(u)) continue;
            cache.release((IdentifiableBean)cache.get(u), this);
        }
        changeManager.notifySave(id);
    }

    public void notifyChangeEvent(IdentifiableChangeEvent event) {
        this.logger.debug((Object)("Received change notification for bean: " + event.getBean().getPrimaryIdentifier() + "."));
        this.processChangeEvent(event);
    }

    @Override
    public synchronized void notifySave(SaveEvent saveEvent) {
        LockingBeanCache cache = this.getLockingBeanCache();
        if (this.saveOperationList.contains(saveEvent.getEventIdentifier())) {
            this.saveOperationList.remove(saveEvent.getEventIdentifier());
            return;
        }
        String[] stringArray = saveEvent.getPrimaryIdentifiers();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (cache.contains(id)) {
                this.revertBean(id);
                this.getChangeManager().notifyDiscard(id);
            }
            ++n2;
        }
    }

    @Override
    public Set<String> getReferrers(String id) {
        this.logger.debug((Object)("Getting referrers for: " + id + "."));
        Set<String> referrers = super.getReferrers(id);
        referrers.addAll(this.localReferenceManager.getReferrerAdditions(id));
        referrers.removeAll(this.localReferenceManager.getReferrerSubtractions(id));
        referrers.removeAll(this.localReferenceManager.getDeletedReferrers());
        return referrers;
    }

    @Override
    public void setBeanCache(BeanCache beanCache) {
        super.setBeanCache(beanCache);
        this.logger.warn((Object)"BeanCache must be set via the LockingBeanCache property. Cache set as BeanCache property will be overridden.");
    }

    public void setLockingBeanCache(LockingBeanCache lockingBeanCache) {
        if (this.lockingBeanCache != null && !this.lockingBeanCache.equals(lockingBeanCache)) {
            throw this.raiseRuntimeException("LockingBeanCache cannot be reset.");
        }
        super.setBeanCache(lockingBeanCache);
        this.lockingBeanCache = lockingBeanCache;
    }

    @Override
    public void setStoreRepository(StoreRepository<Source> storeRepository) {
        super.setStoreRepository(storeRepository);
        this.logger.warn((Object)"StoreRepository must be set via the WorkspaceRespository property. Repository set as StoreRepository property will be overridden.");
    }

    public void setWorkspaceRepository(WorkspaceRepository<Source> workspaceRepository) {
        if (this.workspaceRepository != null && !this.workspaceRepository.equals(workspaceRepository)) {
            throw this.raiseRuntimeException("WorkspaceRepository cannot be reset.");
        }
        super.setStoreRepository(workspaceRepository);
        workspaceRepository.addSaveListener(this);
        this.workspaceRepository = workspaceRepository;
        this.initializeBeanFactory(this.workspaceRepository.getBeanFactory());
        this.initializeMutableDeserializer(this.workspaceRepository.getDeserializer());
        this.initializeChangeManager(this.workspaceRepository.getChangeManager());
    }

    protected final LockingBeanCache getLockingBeanCache() {
        if (this.lockingBeanCache == null) {
            throw this.raiseRuntimeException("LockingBeanCache is not set.");
        }
        return this.lockingBeanCache;
    }

    protected final WorkspaceRepository<Source> getWorkspaceRepository() {
        if (this.workspaceRepository == null) {
            throw this.raiseRuntimeException("WorkspaceRepository is not set.");
        }
        return this.workspaceRepository;
    }

    protected final MutableDeserializer<Source> getMutableDeserializer() {
        if (this.mutableDeserializer == null && this.getWorkspaceRepository().mustDeserialize()) {
            this.initializeMutableDeserializer(this.getWorkspaceRepository().getDeserializer());
        }
        return this.mutableDeserializer;
    }

    protected final void initializeMutableDeserializer(MutableDeserializer<Source> mutableDeserializer) {
        if (mutableDeserializer == null) {
            throw this.raiseRuntimeException("MutableDeserializer cannot be null.");
        }
        if (this.mutableDeserializer != null && !this.mutableDeserializer.equals(mutableDeserializer)) {
            throw this.raiseRuntimeException("MutableDeserializer cannot be reset.");
        }
        super.initializeDeserializer(mutableDeserializer);
        this.mutableDeserializer = mutableDeserializer;
        this.logger.debug((Object)"Setting workspace as change listener to the deserializer.");
        this.mutableDeserializer.setChangeListener((IdentifiableChangeListener)this);
    }

    protected final BeanFactory getBeanFactory() {
        if (this.beanFactory == null) {
            this.initializeBeanFactory(this.getWorkspaceRepository().getBeanFactory());
        }
        return this.beanFactory;
    }

    protected final void initializeBeanFactory(BeanFactory beanFactory) {
        if (beanFactory == null) {
            throw this.raiseRuntimeException("BeanFactory cannot be null.");
        }
        if (this.beanFactory != null && !this.beanFactory.equals(beanFactory)) {
            throw this.raiseRuntimeException("BeanFactory cannot be reset.");
        }
        this.beanFactory = beanFactory;
        this.logger.debug((Object)"Setting workspace as reseolver to the bean factory.");
        this.beanFactory.setResolver((Resolver)this);
        this.logger.debug((Object)"Setting workspace as change listener to the bean factory.");
        this.beanFactory.setChangeListener((IdentifiableChangeListener)this);
    }

    protected final ChangeManager getChangeManager() {
        if (this.changeManager == null) {
            this.initializeChangeManager(this.getWorkspaceRepository().getChangeManager());
        }
        return this.changeManager;
    }

    protected final void initializeChangeManager(ChangeManager changeManager) {
        if (this.changeManager != null && !this.changeManager.equals(changeManager)) {
            throw this.raiseRuntimeException("ChangeManager cannot be reset.");
        }
        this.changeManager = changeManager;
    }

    protected synchronized void performSave(String contextId, ChangeSet<Source> sourceChangeSet) throws InsufficientBeanRightsException {
        this.logger.debug((Object)"Persisting beans.");
        try {
            String saveId = this.getWorkspaceRepository().save(contextId, sourceChangeSet.getAdditions(), sourceChangeSet.getUpdates(), sourceChangeSet.getDeletions());
            this.saveOperationList.add(saveId);
        }
        catch (InsufficientBeanRightsException bre) {
            throw bre;
        }
        catch (StoreException se) {
            throw this.raiseRuntimeException("Error saving changes.", se);
        }
    }

    protected final void addSaveOperation(String operationId) {
        this.saveOperationList.add(operationId);
    }

    protected void processChangeEvent(IdentifiableChangeEvent event) {
        IdentifiableBean bean;
        LockingBeanCache cache = this.getLockingBeanCache();
        if (cache.contains((bean = event.getBean()).getPrimaryIdentifier())) {
            this.logger.debug((Object)"Verifying bean with cache.");
            if (!((IdentifiableBean)cache.get(bean.getPrimaryIdentifier())).equals(bean)) {
                throw this.raiseRuntimeException("Change event bean does not match cached version of the same bean");
            }
        } else {
            this.logger.debug((Object)"Caching bean.");
            cache.add(bean);
        }
        this.logger.debug((Object)"Capturing bean.");
        cache.capture(bean, this);
        ChangeEvent.Type eventType = event.getType();
        this.logger.debug((Object)("Change notification type is: " + eventType + "."));
        if (eventType.equals((Object)ChangeEvent.Type.DELETE)) {
            this.logger.debug((Object)"Updating references to reflect deletion.");
            this.localReferenceManager.addDeletedReferrer(bean.getPrimaryIdentifier());
        }
        this.logger.debug((Object)"Processing reference changes for change event");
        String fromId = event.getBean().getPrimaryIdentifier();
        this.localReferenceManager.addReferences(fromId, event.getNewReferences().toArray(new String[0]));
        this.localReferenceManager.removeReferences(fromId, event.getRemovedReferences().toArray(new String[0]));
        this.logger.debug((Object)"Passing change notification to ChangeManager.");
        this.getChangeManager().notifyChangeEvent(event);
        this.getChangeNotificationManager().notifyChangeEvent(event);
    }

    protected Source serializeBean(IdentifiableBean bean) {
        this.logger.debug((Object)("Searializing bean: " + bean.getPrimaryIdentifier()));
        if (this.getWorkspaceRepository().mustDeserialize()) {
            Serializer<Source> serializer = this.getWorkspaceRepository().getSerializer();
            return (Source)serializer.serialize(serializer.getSourceClass(bean), bean);
        }
        IdentifiableBean source = bean;
        return (Source)source;
    }

    protected void revertBean(String id) {
        LockingBeanCache cache = this.getLockingBeanCache();
        this.localReferenceManager.clear(id);
        if (cache.contains(id)) {
            WorkspaceRepository<Source> repository = this.getWorkspaceRepository();
            if (repository.contains(id)) {
                try {
                    IdentifiableBean bean = (IdentifiableBean)cache.get(id);
                    this.getMutableDeserializer().deserialize(bean, repository.get(id));
                    cache.release(bean, this);
                }
                catch (ObjectNotFoundException onfe) {
                    throw this.raiseRuntimeException("Error reverting bean: " + id, onfe);
                }
            } else {
                cache.remove((IdentifiableBean)cache.get(id));
            }
        }
    }
}

