/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.store.access.impl;

import java.util.Calendar;
import org.openmetadata.store.access.LockInformation;
import org.openmetadata.store.access.User;

public class Locked
implements LockInformation {
    private final String id;
    private final User user;
    private final Calendar lockTime;
    private final Calendar expirationTime;
    private final LockInformation[] children;
    private LockInformation parent;

    public Locked(String id, User user, Calendar lockTime) {
        this(id, user, lockTime, (Calendar)null, new Locked[0]);
    }

    public Locked(String id, User user, Calendar lockTime, Calendar expirationTime) {
        this(id, user, lockTime, expirationTime, new Locked[0]);
    }

    public Locked(String id, User user, Calendar lockTime, Locked ... children) {
        this(id, user, lockTime, (Calendar)null, children);
    }

    public Locked(String id, User user, Calendar lockTime, Calendar expirationTime, Locked ... children) {
        this.id = id;
        this.user = user;
        this.lockTime = lockTime;
        this.expirationTime = expirationTime;
        this.children = children;
        Locked[] lockedArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Locked child = lockedArray[n2];
            if (!child.getUser().equals(user)) {
                throw new IllegalArgumentException("Cannot nest locks for differnt users.");
            }
            child.setParent(this);
            ++n2;
        }
    }

    @Override
    public String getPrimaryIdentifier() {
        return this.id;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public Calendar getLockTime() {
        return this.lockTime;
    }

    @Override
    public boolean hasExpirationTime() {
        return this.expirationTime != null;
    }

    @Override
    public Calendar getExpirationTime() {
        return this.expirationTime;
    }

    @Override
    public boolean isLocked() {
        return true;
    }

    @Override
    public LockInformation[] getChildLocks() {
        return this.children;
    }

    @Override
    public LockInformation getParentLock() {
        return this.parent;
    }

    @Override
    public boolean hasParentLock() {
        return this.parent != null;
    }

    private void setParent(Locked parent) {
        this.parent = parent;
    }
}

