/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.store.access;

public class User {
    private final String id;
    private final String location;
    private final String name;

    public User(String id, String location, String name) {
        if (id == null || location == null || name == null) {
            throw new IllegalArgumentException("Values cannot be null");
        }
        this.id = id;
        this.location = location;
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public String getLocation() {
        return this.location;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.id.toLowerCase().hashCode() + this.location.toLowerCase().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof User)) {
            return false;
        }
        User user = (User)obj;
        return this.id.equalsIgnoreCase(user.getId()) && this.location.equalsIgnoreCase(user.getLocation());
    }
}

