/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.beans.dmp.factory.serializer;

import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.impl.xb.xsdschema.FieldDocument;
import org.openmetadata.beans.ContextualStringBean;
import org.openmetadata.beans.ContextualStructuredStringBean;
import org.openmetadata.beans.IdentifiableBean;
import org.openmetadata.beans.OpenMetadataKey;
import org.openmetadata.beans.dmp.DataManagementPlanBean;
import org.openmetadata.beans.dmp.FieldBean;
import org.openmetadata.beans.dmp.HeadingBean;
import org.openmetadata.beans.dmp.StringBeanList;
import org.openmetadata.beans.dmp.TextBean;
import org.openmetadata.beans.dmp.TextBeanList;
import org.openmetadata.beans.dmp.TopicBean;
import org.openmetadata.beans.dmp.TopicList;
import org.openmetadata.beans.dmp.factory.util.BeanUtilities;
import org.openmetadata.beans.dmp.field.value.BooleanValueBean;
import org.openmetadata.beans.dmp.field.value.DateValueBean;
import org.openmetadata.beans.dmp.field.value.IntegerValueBean;
import org.openmetadata.beans.dmp.field.value.LongStringValueBean;
import org.openmetadata.beans.dmp.field.value.StringValueBean;
import org.openmetadata.beans.serialization.Populator;
import org.openmetadata.xml.core.BooleanType;
import org.openmetadata.xml.core.ContextualStringType;
import org.openmetadata.xml.core.ContextualTextType;
import org.openmetadata.xml.core.DateType;
import org.openmetadata.xml.core.IntegerType;
import org.openmetadata.xml.core.MaintainableReferenceType;
import org.openmetadata.xml.core.SimpleStringType;
import org.openmetadata.xml.report.BooleanFieldType;
import org.openmetadata.xml.report.DateFieldType;
import org.openmetadata.xml.report.FieldType;
import org.openmetadata.xml.report.HeadingDocument;
import org.openmetadata.xml.report.HeadingType;
import org.openmetadata.xml.report.IntegerFieldType;
import org.openmetadata.xml.report.ReportDocument;
import org.openmetadata.xml.report.ReportType;
import org.openmetadata.xml.report.SimpleStringFieldType;
import org.openmetadata.xml.report.StringFieldType;
import org.openmetadata.xml.report.TextFieldType;
import org.openmetadata.xml.report.TopicType;

public class DmpXmlPopulatorImpl
implements Populator<XmlObject> {
    public void populate(XmlObject source, IdentifiableBean bean) {
        if (source instanceof ReportDocument && bean instanceof DataManagementPlanBean) {
            ContextualStringBean csb;
            ReportDocument reportDoc = (ReportDocument)source;
            DataManagementPlanBean dmp = (DataManagementPlanBean)bean;
            final ReportType reportType = reportDoc.addNewReport();
            reportType.setId(dmp.getPrimaryIdentifier());
            reportType.setValidFrom(dmp.getValidFrom());
            reportType.setValidTo(dmp.getValidTo());
            String version = dmp.getVersion();
            reportType.setVersion(version);
            reportType.setVersionDate(dmp.getVersionDate());
            reportType.getNameList().clear();
            ContextualStringBean[] contextualStringBeanArray = (ContextualStringBean[])dmp.getName().getAllValues();
            int n = contextualStringBeanArray.length;
            int n2 = 0;
            while (n2 < n) {
                csb = contextualStringBeanArray[n2];
                ContextualStringType cst = reportType.addNewName();
                cst.setLang(csb.getLanguage());
                try {
                    BeanUtilities.setXHTMLContent((XmlObject)cst, csb.getValue());
                }
                catch (XmlException e) {
                    e.printStackTrace();
                }
                ++n2;
            }
            reportType.getDocumentationList().clear();
            contextualStringBeanArray = (ContextualStructuredStringBean[])dmp.getDocumentation().getAllValues();
            n = contextualStringBeanArray.length;
            n2 = 0;
            while (n2 < n) {
                csb = contextualStringBeanArray[n2];
                ContextualTextType ctt = reportType.addNewDocumentation();
                ctt.setLang(csb.getLanguage());
                for (Map.Entry key : csb.getKeyMap().entrySet()) {
                    if (!((Enum)key.getKey()).equals(OpenMetadataKey.TYPE)) continue;
                    ctt.setType(key.getValue().toString());
                }
                ++n2;
            }
            MaintainableReferenceType xmlDef = reportType.addNewDefinition();
            xmlDef.setId(dmp.getDefinition().getPrimaryIdentifier());
            this.populateTopicList(dmp.getTopics(), new XmlTopicListParent(){

                @Override
                public TopicType addNewTopic() {
                    return reportType.addNewTopic();
                }
            });
        }
    }

    protected void populateTopicList(TopicList topicList, XmlTopicListParent xmlTopicListParent) {
        for (TopicBean topicBean : topicList) {
            TextFieldType textFieldType;
            SimpleStringFieldType stringFieldType;
            FieldBean stringFieldBean;
            TopicType topicType;
            if (topicBean instanceof HeadingBean) {
                HeadingBean headingBean = (HeadingBean)topicBean;
                topicType = xmlTopicListParent.addNewTopic();
                HeadingType headingType = (HeadingType)topicType.substitute(HeadingDocument.type.getDocumentElementName(), HeadingType.type);
                this.populateHeadingXml(headingBean, headingType);
                continue;
            }
            if (!(topicBean instanceof FieldBean)) continue;
            FieldBean fieldBean = (FieldBean)topicBean;
            topicType = xmlTopicListParent.addNewTopic();
            FieldType fieldType = (FieldType)topicType.changeType(FieldType.type);
            fieldType.substitute(FieldDocument.type.getDocumentElementName(), FieldType.type);
            if (fieldBean.getDefinition().getRepresentation().equals(StringValueBean.class)) {
                stringFieldBean = fieldBean;
                stringFieldType = (SimpleStringFieldType)fieldType.changeType(SimpleStringFieldType.type);
                this.populateStringFieldXml((FieldBean<StringValueBean>)stringFieldBean, stringFieldType);
                continue;
            }
            if (fieldBean.getDefinition().getRepresentation().equals(LongStringValueBean.class)) {
                stringFieldBean = fieldBean;
                stringFieldType = (StringFieldType)fieldType.changeType(StringFieldType.type);
                this.populateLongStringFieldXml((FieldBean<LongStringValueBean>)stringFieldBean, (StringFieldType)stringFieldType);
                continue;
            }
            if (fieldBean.getDefinition().getRepresentation().equals(TextBean.class)) {
                FieldBean textFieldBean = fieldBean;
                textFieldType = (TextFieldType)fieldType.changeType(TextFieldType.type);
                this.populateTextFieldXml((FieldBean<TextBean>)textFieldBean, textFieldType);
                continue;
            }
            if (fieldBean.getDefinition().getRepresentation().equals(TextBeanList.class)) {
                FieldBean textListFieldBean = fieldBean;
                textFieldType = (TextFieldType)fieldType.changeType(TextFieldType.type);
                this.populateTextListFieldXml((FieldBean<TextBeanList>)textListFieldBean, textFieldType);
                continue;
            }
            if (fieldBean.getDefinition().getRepresentation().equals(StringBeanList.class)) {
                FieldBean strListFieldBean = fieldBean;
                StringFieldType strFieldType = (StringFieldType)fieldType.changeType(StringFieldType.type);
                this.populateStringListFieldXml((FieldBean<StringBeanList>)strListFieldBean, strFieldType);
                continue;
            }
            if (fieldBean.getDefinition().getRepresentation().equals(BooleanValueBean.class)) {
                FieldBean booleanFieldBean = fieldBean;
                BooleanFieldType booleanFieldType = (BooleanFieldType)fieldType.changeType(BooleanFieldType.type);
                this.populateBooleanFieldXml((FieldBean<BooleanValueBean>)booleanFieldBean, booleanFieldType);
                continue;
            }
            if (fieldBean.getDefinition().getRepresentation().equals(IntegerValueBean.class)) {
                FieldBean integerFieldBean = fieldBean;
                IntegerFieldType integerFieldType = (IntegerFieldType)fieldType.changeType(IntegerFieldType.type);
                this.populateIntegerFieldXml((FieldBean<IntegerValueBean>)integerFieldBean, integerFieldType);
                continue;
            }
            if (!fieldBean.getDefinition().getRepresentation().equals(DateValueBean.class)) continue;
            FieldBean dateFieldBean = fieldBean;
            DateFieldType dateFieldType = (DateFieldType)fieldType.changeType(DateFieldType.type);
            this.populateDateFieldXml((FieldBean<DateValueBean>)dateFieldBean, dateFieldType);
        }
    }

    protected void populateHeadingXml(HeadingBean headingBean, final HeadingType headingType) {
        headingType.setId(headingBean.getPrimaryIdentifier());
        headingType.setTopicDefinition(headingBean.getDefinition().getPrimaryIdentifier());
        this.populateTopicList(headingBean.getTopicList(), new XmlTopicListParent(){

            @Override
            public TopicType addNewTopic() {
                return headingType.addNewTopic();
            }
        });
    }

    protected void populateFieldXml(FieldBean<?> fieldBean, FieldType fieldType) {
        fieldType.setId(fieldBean.getPrimaryIdentifier());
        fieldType.setTopicDefinition(fieldBean.getDefinition().getPrimaryIdentifier());
    }

    protected void populateIntegerFieldXml(FieldBean<IntegerValueBean> fieldBean, IntegerFieldType fieldType) {
        this.populateFieldXml(fieldBean, (FieldType)fieldType);
        if (((IntegerValueBean)fieldBean.getValue()).isSetValue()) {
            int intVal = ((IntegerValueBean)fieldBean.getValue()).getValue();
            BigInteger bigIntVal = BigInteger.valueOf(intVal);
            IntegerType integerType = fieldType.getInteger() != null ? fieldType.getInteger() : fieldType.addNewInteger();
            integerType.setBigIntegerValue(bigIntVal);
        }
    }

    protected void populateBooleanFieldXml(FieldBean<BooleanValueBean> fieldBean, BooleanFieldType fieldType) {
        this.populateFieldXml(fieldBean, (FieldType)fieldType);
        if (((BooleanValueBean)fieldBean.getValue()).isSetValue()) {
            boolean boolVal = ((BooleanValueBean)fieldBean.getValue()).getValue();
            BooleanType booleanType = fieldType.getBoolean() != null ? fieldType.getBoolean() : fieldType.addNewBoolean();
            DmpXmlPopulatorImpl.setTextValueToXmlObject((XmlObject)booleanType, String.valueOf(boolVal));
        }
    }

    protected void populateStringFieldXml(FieldBean<StringValueBean> fieldBean, SimpleStringFieldType fieldType) {
        this.populateFieldXml(fieldBean, (FieldType)fieldType);
        if (((StringValueBean)fieldBean.getValue()).isSetValue()) {
            String str = ((StringValueBean)fieldBean.getValue()).getValue();
            SimpleStringType simStrType = fieldType.getSimpleString() != null ? fieldType.getSimpleString() : fieldType.addNewSimpleString();
            try {
                BeanUtilities.setXHTMLContent((XmlObject)simStrType, str);
            }
            catch (XmlException e) {
                e.printStackTrace();
            }
        }
    }

    protected void populateLongStringFieldXml(FieldBean<LongStringValueBean> fieldBean, StringFieldType fieldType) {
        this.populateFieldXml(fieldBean, (FieldType)fieldType);
        if (((LongStringValueBean)fieldBean.getValue()).isSetValue()) {
            String stringContent = StringEscapeUtils.escapeXml((String)((LongStringValueBean)fieldBean.getValue()).getValue());
            ContextualStringType cst = fieldType.getStringList().size() > 0 ? (ContextualStringType)fieldType.getStringList().get(0) : fieldType.addNewString();
            try {
                BeanUtilities.setXHTMLContent((XmlObject)cst, stringContent);
            }
            catch (XmlException e) {
                e.printStackTrace();
            }
        }
    }

    protected void populateStringListFieldXml(FieldBean<StringBeanList> fieldBean, StringFieldType fieldType) {
        this.populateFieldXml(fieldBean, (FieldType)fieldType);
        fieldType.getStringList().clear();
        StringBeanList strBeanList = (StringBeanList)fieldBean.getValue();
        for (StringValueBean strBean : strBeanList) {
            String string = StringEscapeUtils.escapeXml((String)strBean.getValue());
            ContextualStringType cst = fieldType.addNewString();
            try {
                BeanUtilities.setXHTMLContent((XmlObject)cst, string);
            }
            catch (XmlException e) {
                e.printStackTrace();
            }
        }
    }

    protected void populateTextFieldXml(FieldBean<TextBean> fieldBean, TextFieldType fieldType) {
        this.populateFieldXml(fieldBean, (FieldType)fieldType);
        if (((TextBean)fieldBean.getValue()).isSetValue()) {
            String textContent = ((TextBean)fieldBean.getValue()).getValue();
            ContextualStringType cst = fieldType.getTextList().size() > 0 ? (ContextualStringType)fieldType.getTextList().get(0) : fieldType.addNewText();
            try {
                BeanUtilities.setXHTMLContent((XmlObject)cst, textContent);
            }
            catch (XmlException e) {
                e.printStackTrace();
            }
        }
    }

    protected void populateTextListFieldXml(FieldBean<TextBeanList> fieldBean, TextFieldType fieldType) {
        this.populateFieldXml(fieldBean, (FieldType)fieldType);
        fieldType.getTextList().clear();
        TextBeanList textBeanList = (TextBeanList)fieldBean.getValue();
        for (TextBean textBean : textBeanList) {
            String textContent = textBean.getValue();
            ContextualStringType cst = fieldType.addNewText();
            try {
                BeanUtilities.setXHTMLContent((XmlObject)cst, textContent);
            }
            catch (XmlException e) {
                e.printStackTrace();
            }
        }
    }

    protected void populateDateFieldXml(FieldBean<DateValueBean> fieldBean, DateFieldType fieldType) {
        this.populateFieldXml(fieldBean, (FieldType)fieldType);
        if (((DateValueBean)fieldBean.getValue()).isSetValue()) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            String xmlFormattedTime = format.format(((DateValueBean)fieldBean.getValue()).getValue());
            DateType dateType = fieldType.getDate() != null ? fieldType.getDate() : fieldType.addNewDate();
            DmpXmlPopulatorImpl.setTextValueToXmlObject((XmlObject)dateType, xmlFormattedTime);
        }
    }

    private static void setTextValueToXmlObject(XmlObject xmlObject, String string) {
        XmlCursor cursor = xmlObject.newCursor();
        cursor.toFirstChild();
        cursor.setTextValue(string);
        cursor.dispose();
    }

    static interface XmlTopicListParent {
        public TopicType addNewTopic();
    }
}

